;======================================================================
;======================================================================
; Basic states file for "Kanna"
;======================================================================
;======================================================================

;----------------------------------------------------------------------
; Intro and Matchover
;----------------------------------------------------------------------
;170 		- TimeOver
;180 		- WinPose State Selector
;190 		- Introduction State Selector

[Statedef 170]
type = S
movetype = I
physics = S
anim = 170
ctrl = 0
velset = 0,0

[State 170, NotHitBy]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

[Statedef 180]
type = S
movetype = I
physics = S
ctrl = 0
velset = 0,0

[State 180, ChangeState]
type = ChangeState
triggerall = RoundState != 0
trigger1 = Time = 0
value = 3000

[Statedef 190]
type = S
movetype = I
physics = S
anim = 99990
ctrl = 0
velset = 0,0

[State 190, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = Intro

[State 190, ChangeState]
type = ChangeState
trigger1 = Random % 2 = 0
value = 4000

[State 190, ChangeState]
type = ChangeState
trigger1 = Random % 2 = 1
value = 4010

;----------------------------------------------------------------------
; Basic Moves
;----------------------------------------------------------------------

;----------------------------------------------------------------------
; Stand Light Attack

[Statedef 200]
type = S
movetype = A
physics = S
anim = 200
ctrl = 0
poweradd = 20

[State 200, VarSet];Hitsound and effects select
type = VarSet
trigger1 = Time = 0
var(0) = 1
ignorehitpause = 1

[State 200, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(1) = 0
ignorehitpause = 1

[State 200, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(2) = 0
ignorehitpause = 1

[State 200, VarSet];Damage Correction
type = VarSet
trigger1 = Time = 0
fvar(3) = 0.055
ignorehitpause = 1

[State 200, VarSet];Fall.RecoverTime
type = VarSet
trigger1 = Time = 0
fvar(4) = 30
ignorehitpause = 1

[State 200, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(4) = 0
value = s0,0
channel = 1
ignorehitpause = 1

[State 200, Hitdef]
type = Hitdef
triggerall = var(4) = 1
trigger1 = AnimElem = 4
attr = S,NA
hitflag = MAF
guardflag = M
animtype = light
air.animtype = back
fall.animtype = back
ground.type = high
air.type = high
damage = ceil(fvar(0)*19),0
getpower = 25,5
givepower = 8,3
pausetime = 10,10
guard.pausetime = 10,10
sparkno = S10200
guard.sparkno = S10270
sparkxy = -30+random%20,-75+random%20
hitsound = -1,0
guardsound = -1,0
ground.slidetime = 10
ground.hittime = 10
guard.hittime = 9
air.hittime = 10
guard.ctrltime = 9
airguard.ctrltime = 9
ground.velocity = -5,0
guard.velocity = -5
air.velocity = -2.5,ifelse(EnemyNear,Vel Y <= 0,(-5.5+EnemyNear,Vel Y*0.25),-5.25)
airguard.velocity = -1.5,-3
ground.cornerpush.veloff = fvar(17)-3.0
air.cornerpush.veloff = 0
down.cornerpush.veloff = -3.0
guard.cornerpush.veloff = -3.0
airguard.cornerpush.veloff = 0
fall.recover = 1
fall.recovertime = ceil(fvar(6))
forcestand = 0
fall = 0
air.fall = 1
kill = 1
guard.kill = 0
yaccel = 0.4

[State 200, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;----------------------------------------------------------------------
; Stand Medium Attack

[Statedef 210]
type = S
movetype = A
physics = S
anim = 210
ctrl = 0
poweradd = 35

[State 210, VarSet];Hitsound and effects select
type = VarSet
trigger1 = Time = 0
var(0) = 4
ignorehitpause = 1

[State 210, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(1) = 0
ignorehitpause = 1

[State 210, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(2) = 0
ignorehitpause = 1

[State 210, VarSet];Damage Correction
type = VarSet
trigger1 = Time = 0
fvar(3) = 0.07
ignorehitpause = 1

[State 210, VarSet];Fall.RecoverTime
type = VarSet
trigger1 = Time = 0
fvar(4) = 40
ignorehitpause = 1

[State 210, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(3) = 0
value = s0,1
channel = 1
ignorehitpause = 1

[State 210, Explod]
type = Explod
trigger1 = AnimElemTime(1) = 1
anim = 2210
ID = 2000
postype = p1
pos = -23,31
bindtime = -1
removetime = -2
removeongethit = 1
ownpal = 1
supermovetime = 0
pausemovetime = 0
sprpriority = 3
ignorehitpause = 0

[State 210, Hitdef]
type = Hitdef
triggerall = var(4) = 1
trigger1 = AnimElem = 4
attr = S,NA
hitflag = MAF
guardflag = M
animtype = Medium
air.animtype = back
fall.animtype = back
ground.type = high
air.type = high
damage = ceil(fvar(0)*50),0
getpower = 35,7
givepower = 14,7
pausetime = 10,10
guard.pausetime = 10,10
sparkno = S10240
guard.sparkno = S10270
sparkxy = -30+random%20,-75+random%20
hitsound = -1,0
guardsound = -1,0
ground.slidetime = 16
ground.hittime = 16
guard.hittime = 14
air.hittime = 16
guard.ctrltime = 14
airguard.ctrltime = 14
ground.velocity = -5,0
guard.velocity = -5
air.velocity = -1.5,-6.5
airguard.velocity = -1.5,-3
ground.cornerpush.veloff = fvar(17)-7.0
air.cornerpush.veloff = 0
down.cornerpush.veloff = -3.0
guard.cornerpush.veloff = -3.0
airguard.cornerpush.veloff = 0
fall.recover = 1
fall.recovertime = ceil(fvar(6))
forcestand = 0
fall = 0
air.fall = 1
kill = 1
guard.kill = 0
yaccel = 0.4

[State 210, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;----------------------------------------------------------------------
; Stand Medium Attack(Far)

[Statedef 220]
type = S
movetype = A
physics = S
anim = 220
ctrl = 0
poweradd = 35

[State 220, VarSet];Hitsound and effects select
type = VarSet
trigger1 = Time = 0
var(0) = 4
ignorehitpause = 1

[State 220, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(1) = 0
ignorehitpause = 1

[State 220, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(2) = 0
ignorehitpause = 1

[State 220, VarSet];Damage Correction
type = VarSet
trigger1 = Time = 0
fvar(3) = 0.05
ignorehitpause = 1

[State 220, VarSet];Fall.RecoverTime
type = VarSet
trigger1 = Time = 0
fvar(4) = 40
ignorehitpause = 1

[State 220, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(5) = 0
value = s0,1
channel = 1
ignorehitpause = 1

[State 220, Explod]
type = Explod
trigger1 = AnimElemTime(3) = 1
anim = 2220
ID = 2000
postype = p1
pos = 40,-45
bindtime = -1
removetime = -2
removeongethit = 1
ownpal = 1
supermovetime = 0
pausemovetime = 0
sprpriority = 3
ignorehitpause = 0

[State 220, Hitdef]
type = Hitdef
triggerall = var(4) = 1
trigger1 = AnimElem = 7
attr = S,NA
hitflag = MAF
guardflag = M
animtype = Medium
air.animtype = back
fall.animtype = back
ground.type = high
air.type = high
damage = ceil(fvar(0)*55),0
getpower = 35,7
givepower = 14,7
pausetime = 10,10
guard.pausetime = 10,10
sparkno = S10230
guard.sparkno = S10270
sparkxy = -30+random%20,-75+random%20
hitsound = -1,0
guardsound = -1,0
ground.slidetime = 16
ground.hittime = 16
guard.hittime = 14
air.hittime = 16
guard.ctrltime = 14
airguard.ctrltime = 14
ground.velocity = -5,0
guard.velocity = -5
air.velocity = -5,ifelse(EnemyNear,Vel Y <= 0,(-4.75+EnemyNear,Vel Y*0.25),-5.25)
airguard.velocity = -1.5,-3
ground.cornerpush.veloff = fvar(17)-7.0
air.cornerpush.veloff = 0
down.cornerpush.veloff = -3.0
guard.cornerpush.veloff = -3.0
airguard.cornerpush.veloff = 0
fall.recover = 1
fall.recovertime = ceil(fvar(6))
forcestand = 0
fall = 0
air.fall = 1
kill = 1
guard.kill = 0
yaccel = 0.4

[State 220, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;----------------------------------------------------------------------
; Stand Strong Attack

[Statedef 230]
type = S
movetype = A
physics = S
anim = 230
ctrl = 0
poweradd = 50

[State 230, VarSet];Hitsound and effects select
type = VarSet
trigger1 = Time = 0
var(0) = 4
ignorehitpause = 1

[State 230, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(1) = 0
ignorehitpause = 1

[State 230, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(2) = 0
ignorehitpause = 1

[State 230, VarSet];Damage Correction
type = VarSet
trigger1 = Time = 0
fvar(3) = 0.06
ignorehitpause = 1

[State 230, VarSet];Fall.RecoverTime
type = VarSet
trigger1 = Time = 0
fvar(4) = 40
ignorehitpause = 1

[State 230, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(7) = 0
value = s0,2
channel = 1
ignorehitpause = 1

[State 230, Explod]
type = Explod
trigger1 = AnimElemTime(6) = 1
anim = 2230
ID = 2000
postype = p1
pos = 25,10
bindtime = -1
removetime = -2
removeongethit = 1
ownpal = 1
supermovetime = 0
pausemovetime = 0
sprpriority = 3
ignorehitpause = 0

[State 230, Hitdef]
type = Hitdef
triggerall = var(4) = 1
trigger1 = AnimElem = 7
attr = S,NA
hitflag = MAF
guardflag = M
animtype = Medium
air.animtype = back
fall.animtype = back
ground.type = high
air.type = high
damage = ceil(fvar(0)*80),0
getpower = 50,25
givepower = 25,15
pausetime = 10,10
guard.pausetime = 10,10
sparkno = S10240
guard.sparkno = S10270
sparkxy = -30+random%20,-75+random%20
hitsound = -1,0
guardsound = -1,0
ground.slidetime = 23
ground.hittime = 23
guard.hittime = 21
air.hittime = 23
guard.ctrltime = 21
airguard.ctrltime = 21
ground.velocity = -5,0
guard.velocity = -5
air.velocity = -2.5,4.5
airguard.velocity = -1.5,-3
ground.cornerpush.veloff = fvar(17)-11.0
air.cornerpush.veloff = 0
down.cornerpush.veloff = -3.0
guard.cornerpush.veloff = -3.0
airguard.cornerpush.veloff = 0
fall.recover = 0
forcestand = 0
fall = 0
air.fall = 1
kill = 1
guard.kill = 0
yaccel = 0.4

[State 230, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;----------------------------------------------------------------------
; Crouch Light Attack

[Statedef 300]
type = C
movetype = A
physics = C
anim = 300
ctrl = 0
poweradd = 20

[State 300, VarSet];Hitsound and effects select
type = VarSet
trigger1 = Time = 0
var(0) = 1
ignorehitpause = 1

[State 300, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(1) = 0
ignorehitpause = 1

[State 300, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(2) = 0
ignorehitpause = 1

[State 300, VarSet];Damage Correction
type = VarSet
trigger1 = Time = 0
fvar(3) = 0.06
ignorehitpause = 1

[State 300, VarSet];Fall.RecoverTime
type = VarSet
trigger1 = Time = 0
fvar(4) = 30
ignorehitpause = 1

[State 300, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(3) = 0
value = s0,0
channel = 1
ignorehitpause = 1

[State 300, Hitdef]
type = Hitdef
triggerall = var(4) = 1
trigger1 = AnimElem = 3
attr = C,NA
hitflag = MAF
guardflag = L
animtype = light
air.animtype = back
fall.animtype = back
ground.type = low
air.type = low
damage = ceil(fvar(0)*18),0
getpower = 25,5
givepower = 8,3
pausetime = 10,10
guard.pausetime = 10,10
sparkno = S10200
guard.sparkno = S10270
sparkxy = -30+random%20,-20+random%20
hitsound = -1,0
guardsound = -1,0
ground.slidetime = 10
ground.hittime = 9
guard.hittime = 8
air.hittime = 9
guard.ctrltime = 10
airguard.ctrltime = 10
ground.velocity = -4.25,0
guard.velocity = -4.25
air.velocity = -2.5,ifelse(EnemyNear,Vel Y <= 0,(-3.75+EnemyNear,Vel Y*0.25),-2.75)
airguard.velocity = -1.5,-3
ground.cornerpush.veloff = fvar(17)-4.0
air.cornerpush.veloff = 0
down.cornerpush.veloff = -4.4
guard.cornerpush.veloff = -4.4
airguard.cornerpush.veloff = 0
fall.recover = 1
fall.recovertime = ceil(fvar(6))
forcestand = 0
fall = 0
air.fall = 1
kill = 1
guard.kill = 0
yaccel = 0.4

[State 300, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
value = 11
ctrl = 1

;----------------------------------------------------------------------
; Crouch Medium Attack

[Statedef 310]
type = C
movetype = A
physics = C
anim = 310
ctrl = 0
poweradd = 35

[State 310, VarSet];Hitsound and effects select
type = VarSet
trigger1 = Time = 0
var(0) = 4
ignorehitpause = 1

[State 310, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(1) = 0
ignorehitpause = 1

[State 310, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(2) = 0
ignorehitpause = 1

[State 310, VarSet];Damage Correction
type = VarSet
trigger1 = Time = 0
fvar(3) = 0.06
ignorehitpause = 1

[State 310, VarSet];Fall.RecoverTime
type = VarSet
trigger1 = Time = 0
fvar(4) = 40
ignorehitpause = 1

[State 310, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(4) = 0
value = s0,1
channel = 1
ignorehitpause = 1

[State 310, Explod]
type = Explod
trigger1 = AnimElemTime(2) = 1
anim = 2310
ID = 2000
postype = p1
pos = -34,-11
bindtime = -1
removetime = -2
removeongethit = 1
ownpal = 1
supermovetime = 0
pausemovetime = 0
sprpriority = 3
ignorehitpause = 0

[State 310, Hitdef]
type = Hitdef
triggerall = var(4) = 1
trigger1 = AnimElem = 5
attr = C,NA
hitflag = MAF
guardflag = L
animtype = Medium
air.animtype = back
fall.animtype = back
ground.type = low
air.type = low
damage = ceil(fvar(0)*52),0
getpower = 35,7
givepower = 14,7
pausetime = 10,10
guard.pausetime = 10,10
sparkno = S10250
guard.sparkno = S10270
sparkxy = -30+random%20,-40+random%20
hitsound = -1,0
guardsound = -1,0
ground.slidetime = 16
ground.hittime = 16
guard.hittime = 14
air.hittime = 16
guard.ctrltime = 14
airguard.ctrltime = 14
ground.velocity = -4.25,0
guard.velocity = -4.25
air.velocity = -2.5,ifelse(EnemyNear,Vel Y <= 0,(-3.75+EnemyNear,Vel Y*0.25),-2.75)
airguard.velocity = -1.5,-3
ground.cornerpush.veloff = fvar(17)-7.0
air.cornerpush.veloff = 0
down.cornerpush.veloff = 0
guard.cornerpush.veloff = -5.0
airguard.cornerpush.veloff = 0
fall.recover = 1
fall.recovertime = ceil(fvar(6))
forcestand = 0
fall = 0
air.fall = 1
kill = 1
guard.kill = 0
yaccel = 0.4

[State 310, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
value = 11
ctrl = 1

;----------------------------------------------------------------------
; Crouch Strong Attack

[Statedef 320]
type = C
movetype = A
physics = C
anim = 320
ctrl = 0
poweradd = 50

[State 320, VarSet];Hitsound and effects select
type = VarSet
trigger1 = Time = 0
var(0) = 3
ignorehitpause = 1

[State 320, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(1) = 0
ignorehitpause = 1

[State 320, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(2) = 0
ignorehitpause = 1

[State 320, VarSet];Damage Correction
type = VarSet
trigger1 = Time = 0
fvar(3) = 0.06
ignorehitpause = 1

[State 320, VarSet];Fall.RecoverTime
type = VarSet
trigger1 = Time = 0
fvar(4) = 40
ignorehitpause = 1

[State 320, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(5) = 0
value = s0,1
channel = 1
ignorehitpause = 1

[State 320, Hitdef]
type = Hitdef
triggerall = var(4) = 1
trigger1 = AnimElem = 6
attr = C,NA
hitflag = MAF
guardflag = M
animtype = Medium
air.animtype = back
fall.animtype = back
ground.type = low
air.type = low
damage = ceil(fvar(0)*75),0
getpower = 50,25
givepower = 25,15
pausetime = 10,10
guard.pausetime = 10,10
sparkno = S10220
guard.sparkno = S10270
sparkxy = -30+random%20,-60+random%20
hitsound = -1,0
guardsound = -1,0
ground.slidetime = 16
ground.hittime = 16
guard.hittime = 14
air.hittime = 16
guard.ctrltime = 14
airguard.ctrltime = 14
ground.velocity = -6.5,0
guard.velocity = -6.5
air.velocity = -0.5,ifelse(EnemyNear,Vel Y <= 0,(-12.5+EnemyNear,Vel Y*0.25),-3.75)
airguard.velocity = -1.5,-3
ground.cornerpush.veloff = fvar(17)-9.0
air.cornerpush.veloff = 0
down.cornerpush.veloff = 0
guard.cornerpush.veloff = -5.0
airguard.cornerpush.veloff = 0
fall.recover = 1
fall.recovertime = ceil(fvar(6))
forcestand = 0
fall = 0
air.fall = 1
kill = 1
guard.kill = 0
yaccel = 0.4

[State 320, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
value = 11
ctrl = 1

;----------------------------------------------------------------------
; Ariel Light Attack

[Statedef 400]
type = A
movetype = A
physics = A
anim = 400
ctrl = 0
poweradd = 20

[State 400, VarSet];Hitsound and effects select
type = VarSet
trigger1 = Time = 0
var(0) = 4
ignorehitpause = 1

[State 400, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(1) = 0
ignorehitpause = 1

[State 400, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(2) = 0
ignorehitpause = 1

[State 400, VarSet];Damage Correction
type = VarSet
trigger1 = Time = 0
fvar(3) = 0.065
ignorehitpause = 1

[State 400, VarSet];Fall.RecoverTime
type = VarSet
trigger1 = Time = 0
fvar(4) = 30
ignorehitpause = 1

[State 400, VarSet];PrevStateNo
type = VarSet
trigger1 = PrevStateNo = [100,105]
var(10) = 1
ignorehitpause = 1

[State 400, VelAdd]
type = VelAdd
trigger1 = var(10) = 1
y = Const(Movement.yaccel)*0.6

[State 400, StateTypeSet]
type = StateTypeSet
trigger1 = var(10) = 1
trigger1 = Time = 0
physics = N

[State 400, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(3) = 0
value = s0,0
channel = 1
ignorehitpause = 1

[State 400, Hitdef]
type = Hitdef
triggerall = var(4) = 1
trigger1 = AnimElem = 5
attr = A,NA
hitflag = MAF
guardflag = HA
animtype = light
air.animtype = back
fall.animtype = back
ground.type = High
air.type = High
damage = ceil(fvar(0)*21),0
getpower = 25,5
givepower = 8,3
pausetime = 10,10
guard.pausetime = 10,10
sparkno = S10230
guard.sparkno = S10270
sparkxy = -30+random%20,-30+random%20
hitsound = -1,0
guardsound = -1,0
ground.slidetime = 10
ground.hittime = 10
guard.hittime = 9
air.hittime = 10
guard.ctrltime = 10
airguard.ctrltime = 10
ground.velocity = -3,0
guard.velocity = -3
air.velocity = -1.5,ifelse(EnemyNear,Vel Y <= 0,(-5.5+EnemyNear,Vel Y*0.25),-5.25)
airguard.velocity = -1.5,-3
ground.cornerpush.veloff = fvar(17)-0.2
air.cornerpush.veloff = 0
down.cornerpush.veloff = 0
guard.cornerpush.veloff = 0
airguard.cornerpush.veloff = 0
fall.recover = 1
fall.recovertime = ceil(fvar(6))
forcestand = 0
fall = 0
air.fall = 1
kill = 1
guard.kill = 0
yaccel = 0.4

[State 400, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
value = 60
ctrl = 1

[State 400, ChangeState]
type = ChangeState
trigger1 = Pos Y >= 0
value = 52

;----------------------------------------------------------------------
; Ariel Medium Attack

[Statedef 410]
type = A
movetype = A
physics = A
anim = 410
ctrl = 0
poweradd = 35

[State 410, VarSet];Hitsound and effects select
type = VarSet
trigger1 = Time = 0
var(0) = 4
ignorehitpause = 1

[State 410, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(1) = 0
ignorehitpause = 1

[State 410, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(2) = 0
ignorehitpause = 1

[State 410, VarSet];Damage Correction
type = VarSet
trigger1 = Time = 0
fvar(3) = 0.075
ignorehitpause = 1

[State 410, VarSet];Fall.RecoverTime
type = VarSet
trigger1 = Time = 0
fvar(4) = 40
ignorehitpause = 1

[State 410, VarSet];PrevStateNo
type = VarSet
trigger1 = PrevStateNo = [100,105]
var(10) = 1
ignorehitpause = 1

[State 410, VelAdd]
type = VelAdd
trigger1 = var(10) = 1
y = Const(Movement.yaccel)*0.6

[State 410, StateTypeSet]
type = StateTypeSet
trigger1 = var(10) = 1
trigger1 = Time = 0
physics = N

[State 410, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(3) = 0
value = s0,1
channel = 1
ignorehitpause = 1

[State 410, Explod]
type = Explod
trigger1 = AnimElemTime(3) = 1
anim = 2410
ID = 2400
postype = p1
pos = 60,37
bindtime = -1
removetime = -2
removeongethit = 1
ownpal = 1
supermovetime = 0
pausemovetime = 0
sprpriority = 3
ignorehitpause = 0

[State 410, Hitdef]
type = Hitdef
triggerall = var(4) = 1
trigger1 = AnimElem = 6
attr = A,NA
hitflag = MAF
guardflag = HA
animtype = Medium
air.animtype = back
fall.animtype = back
ground.type = High
air.type = High
damage = ceil(fvar(0)*50),0
getpower = 35,7
givepower = 14,7
pausetime = 10,10
guard.pausetime = 10,10
sparkno = S10240
guard.sparkno = S10270
sparkxy = -30+random%20,-30+random%20
hitsound = -1,0
guardsound = -1,0
ground.slidetime = 16
ground.hittime = 16
guard.hittime = 14
air.hittime = 16
guard.ctrltime = 14
airguard.ctrltime = 14
ground.velocity = -3,0
guard.velocity = -3
air.velocity = -4.25,ifelse(EnemyNear,Vel Y <= 0,(-2.0+EnemyNear,Vel Y*0.25),-1.75)
airguard.velocity = -1.5,-3
ground.cornerpush.veloff = fvar(17)-6.0
air.cornerpush.veloff = 0
down.cornerpush.veloff = 0
guard.cornerpush.veloff = 0
airguard.cornerpush.veloff = 0
fall.recover = 1
fall.recovertime = ceil(fvar(6))
forcestand = 0
fall = 0
air.fall = 1
kill = 1
guard.kill = 0
yaccel = 0.4

[State 410, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
value = 60
ctrl = 1

[State 410, ChangeState]
type = ChangeState
trigger1 = Pos Y >= 0
value = 52

;----------------------------------------------------------------------
; Ariel Strong Attack

[Statedef 420]
type = A
movetype = A
physics = A
anim = 420
ctrl = 0
poweradd = 50

[State 420, VarSet];Hitsound and effects select
type = VarSet
trigger1 = Time = 0
var(0) = 4
ignorehitpause = 1

[State 420, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(1) = 0
ignorehitpause = 1

[State 420, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(2) = 0
ignorehitpause = 1

[State 420, VarSet];Damage Correction
type = VarSet
trigger1 = Time = 0
fvar(3) = 0.08
ignorehitpause = 1

[State 420, VarSet];Fall.RecoverTime
type = VarSet
trigger1 = Time = 0
fvar(4) = 40
ignorehitpause = 1

[State 420, VarSet];PrevStateNo
type = VarSet
trigger1 = PrevStateNo = [100,105]
var(10) = 1
ignorehitpause = 1

[State 420, VelAdd]
type = VelAdd
trigger1 = var(10) = 1
y = Const(Movement.yaccel)*0.6

[State 420, StateTypeSet]
type = StateTypeSet
trigger1 = var(10) = 1
trigger1 = Time = 0
physics = N

[State 420, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(3) = 0
value = s0,1
channel = 1
ignorehitpause = 1

[State 420, Explod]
type = Explod
trigger1 = AnimElemTime(2) = 1
anim = 2420
ID = 2400
postype = p1
pos = 37,42
bindtime = -1
removetime = -2
removeongethit = 1
ownpal = 1
supermovetime = 0
pausemovetime = 0
sprpriority = 3
ignorehitpause = 0

[State 420, Hitdef]
type = Hitdef
triggerall = var(4) = 1
trigger1 = AnimElem = 5
attr = A,NA
hitflag = MAF
guardflag = HA
animtype = Medium
air.animtype = back
fall.animtype = back
ground.type = High
air.type = High
damage = ceil(fvar(0)*80),0
getpower = 50,25
givepower = 25,15
pausetime = 10,10
guard.pausetime = 10,10
sparkno = S10250
guard.sparkno = S10270
sparkxy = -30+random%20,-30+random%20
hitsound = -1,0
guardsound = -1,0
ground.slidetime = 16
ground.hittime = 16
guard.hittime = 14
air.hittime = 16
guard.ctrltime = 14
airguard.ctrltime = 14
ground.velocity = -6,0
guard.velocity = -6
air.velocity = -8.25,4.5
airguard.velocity = -1.5,-3
ground.cornerpush.veloff = 0
air.cornerpush.veloff = 0
down.cornerpush.veloff = 0
guard.cornerpush.veloff = 0
airguard.cornerpush.veloff = 0
fall.recover = 0
forcestand = 0
fall = 0
air.fall = 1
kill = 1
guard.kill = 0
yaccel = 0.6

[State 420, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
value = 60
ctrl = 1

[State 420, ChangeState]
type = ChangeState
trigger1 = Pos Y >= 0
value = 52

;---------------------------------------------------------------------------
; Instant Charge

[Statedef 600]
type = S
movetype = A
physics = S
anim = 600
ctrl = 0
velset = 0,0

[State 600, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = NoBG
ignorehitpause = 1

[State 600, PosFreeze]
type = PosFreeze
trigger1 = 1
value = 1
ignorehitpause = 1

[State 600, VelSet]
type = VelSet
trigger1 = 1
x = 0
y = 0
ignorehitpause = 1

[State 600, Pause]
type = Pause 
trigger1 = Time = 0
time = 30
movetime = 30
ignorehitpause = 1

[State 600, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(1) = 0
ignorehitpause = 1

[State 600, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(2) = 0
ignorehitpause = 1

[State 600, VarSet]
type = VarSet
trigger1 = Time = 0
fvar(2) = fvar(2)*(1.0-fvar(1))
ignorehitpause = 1

[State 600, VarSet];Damage Correction
type = VarAdd
trigger1 = Time = 0
trigger1 = fvar(16) = 3
fvar(2) = fvar(15)/200
persistent = 0
ignorehitpause = 1

[State 600, VarSet];RainForce Gauge initialize
type = VarSet
trigger1 = Time = 1
fvar(15) = 0
ignorehitpause = 1

[State 600, VarSet];Flicker Instant Charge Flag initialize
type = VarSet
trigger1 = Time = 2
trigger1 = var(16) = 1
var(16) = 0
ignorehitpause = 1

[State 600, VarSet];Correction
type = VarSet
trigger1 = Time = 2
fvar(18) = 1
ignorehitpause = 1

[State 600, PlaySnd]
type = PlaySnd
trigger1 = Time = 0
value = s2,3
ignorehitpause = 1

[State 600, Explod]
type = Explod
trigger1 = Time = 0
anim = 10600
postype = p1
pos = 0,0
facing = 1
bindtime = -1
removetime = -2
ownpal = 1
supermovetime = 9999
pausemovetime = 9999
sprpriority = 3

[State 600, Explod]
type = Explod
trigger1 = Time = 0
anim = 10601
postype = p1
pos = 0,0
facing = 1
bindtime = -1
removetime = -2
ownpal = 1
supermovetime = 9999
pausemovetime = 9999
sprpriority = 2

[State 600, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Instant Charge

[Statedef 610]
type = A
movetype = A
physics = N
anim = 600
ctrl = 0

[State 610, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = NoBG
ignorehitpause = 1

[State 610, PosFreeze]
type = PosFreeze
trigger1 = 1
value = 1

[State 610, Pause]
type = Pause 
trigger1 = Time = 0
time = 30
movetime = 30
ignorehitpause = 1

[State 610, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(1) = 0
ignorehitpause = 1

[State 610, VarSet];MoveContact initialize
type = VarSet
trigger1 = Time = 0
var(2) = 0
ignorehitpause = 1

[State 610, VarSet]
type = VarSet
trigger1 = Time = 0
fvar(2) = fvar(2)*(1.0-fvar(1))
ignorehitpause = 1

[State 610, VarSet];Damage Correction
type = VarAdd
trigger1 = Time = 0
trigger1 = fvar(16) = 3
fvar(2) = fvar(15)/200
persistent = 0
ignorehitpause = 1

[State 610, VarSet];RainForce Gauge initialize
type = VarSet
trigger1 = Time = 1
fvar(15) = 0
ignorehitpause = 1

[State 610, VarSet];Flicker Instant Charge Flag initialize
type = VarSet
trigger1 = Time = 2
trigger1 = var(16) = 1
var(16) = 0
ignorehitpause = 1

[State 610, VarSet];Correction
type = VarSet
trigger1 = Time = 2
fvar(18) = 1
ignorehitpause = 1

[State 610, VarSet];Air Jump flag initialize
type = VarSet
trigger1 = Time = 0
var(5) = 0

[State 610, VarSet];Air Dash flag initialize
type = VarSet
trigger1 = Time = 0
var(7) = 0

[State 610, VarSet];Save Velocity
type = VarSet
trigger1 = Time = 0
fvar(20) = Vel X
ignorehitpause = 1

[State 610, VarSet];Save Velocity
type = VarSet
trigger1 = Time = 0
fvar(21) = Vel Y
ignorehitpause = 1

[State 610, VelSet]
type = VelSet
trigger1 = Time = 1
x = 0
y = 0

[State 610, VelSet]
type = VelSet
trigger1 = AnimTime = 0
x = fvar(20)
y = fvar(21)

[State 610, StateTypeSet]
type = StateTypeSet
trigger1 = AnimTime = 0
statetype = A
physics = A

[State 610, PlaySnd]
type = PlaySnd
trigger1 = Time = 0
value = s2,3
ignorehitpause = 1

[State 610, Explod]
type = Explod
trigger1 = Time = 0
anim = 10600
postype = p1
pos = 0,-40
facing = 1
bindtime = -1
removetime = -2
ownpal = 1
supermovetime = 9999
pausemovetime = 9999
sprpriority = 3

[State 610, Explod]
type = Explod
trigger1 = Time = 0
anim = 10601
postype = p1
pos = 0,0
facing = 1
bindtime = -1
removetime = -2
ownpal = 1
supermovetime = 9999
pausemovetime = 9999
sprpriority = 2

[State 610, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
value = 53
ctrl = 1

;---------------------------------------------------------------------------
; Intro 1

[Statedef 4000]
type = S
movetype = I
physics = S
anim = 4000
ctrl = 0
velset = 0,0

[State 4000, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = Intro

[State 4000, NotHitBy]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

[State 4000, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 0

;---------------------------------------------------------------------------
; Intro 2

[Statedef 4010]
type = A
movetype = I
physics = N
anim = 0
ctrl = 0

[State 4010, ScreenBound]
type = ScreenBound
trigger1 = 1
value = 1
movecamera = 0,0

[State 4010, PosSet]
type = PosSet
trigger1 = Time = 0
y = -320
ignorehitpause = 1

[State 4010, VelSet]
type = VelSet
trigger1 = Time = 1
y = 1
ignorehitpause = 1

[State 4010, PlaySnd]
type = PlaySnd
trigger1 = Time = 5
value = s3,3
ignorehitpause = 1

[State 4010, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = Intro

[State 4010, NotHitBy]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

[State 4010, ChangeState]
type = ChangeState
trigger1 = Time > 5
trigger1 = Pos Y >= 0
value = 4011

;---------------------------------------------------------------------------
; Intro 2

[Statedef 4011]
type = S
movetype = I
physics = S
ctrl = 0
velset = 0,0

[State 4011, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = Intro

[State 4011, NotHitBy]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

[State 4011, PosSet]
type = PosSet
trigger1 = 1
y = 0
ignorehitpause = 1

[State 4011, ChangeState]
type = ChangeState
trigger1 = Time >= 1
value = 0

;----------------------------------------------------------------------
; WinPose

[Statedef 3000]
type = S
movetype = I
physics = S
anim = 3000
velset = 0,0
ctrl = 0

[State 3000, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = RoundNotOver

[State 3000, Explod]
type = Explod
trigger1 = AnimElemTime(8) = 0
anim = 13000
postype = p1
pos = -50,-70
facing = 1
bindtime = 1
vel = -10,0.5
removetime = 100
ownpal = 1
supermovetime = 9999
pausemovetime = 9999
sprpriority = 2

[State 3000, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
value = 3001
ctrl = 0

;----------------------------------------------------------------------
; WinPose

[Statedef 3001]
type = S
movetype = A
physics = S
anim = 3001
ctrl = 0
velset = 0,0

[State 3000, AssertSpecial]
type = AssertSpecial
trigger1 = Time < 180
flag = RoundNotOver

[State 3001, VarRandom]
type = VarRandom
trigger1 = 1
v = 11
range = 40,240
ignorehitpause = 1

[State 3001, Helper]
type = Helper
trigger1 = Time % 3 = 0
helpertype = normal
name = "Wing"
postype = p1
pos = -320,60-var(11)
ownpal = 1
stateno = 13000
ID = 13000
pausemovetime = 0
supermovetime = 0
ignorehitpause = 1

